(function($) {
    "use strict";

    $(window).on("load", function() {

        // Download
        if ($('.download_items').length) {
            $('.download-filter ul li').on("click", function() {
                $(".download-filter ul li").removeClass("select-cat");
                $(this).addClass("select-cat");
            });
        }

        // Newest
        if ($('.newest_items').length) {
            $('.newest-filter ul li').on("click", function() {
                $(".newest-filter ul li").removeClass("select-cat");
                $(this).addClass("select-cat");
            });
        }


    }); // window load end 3




    // Elementor front-end
    $(window).on('elementor/frontend/init', function() {


        elementorFrontend.hooks.addAction('frontend/element_ready/accordion.default', function($scope, $) {

          


                // Element.
                $('.wd-accordion').each(function() {
                    var $wrapper = $(this);
                    var $tabTitles = $wrapper.find('> .wd-accordion-item > .wd-accordion-title');
                    var $tabContents = $wrapper.find('> .wd-accordion-item > .wd-accordion-content');
                    var activeClass = 'wd-active';
                    var state = $wrapper.data('state');
                    var time = 300;
        
                    if ($wrapper.hasClass('wd-inited')) {
                        return;
                    }
        
                    var isTabActive = function(tabIndex) {
                        return $tabTitles.filter('[data-accordion-index="' + tabIndex + '"]').hasClass(activeClass);
                    };
        
                    var activateTab = function(tabIndex) {
                        var $requestedTitle = $tabTitles.filter('[data-accordion-index="' + tabIndex + '"]');
                        var $requestedContent = $tabContents.filter('[data-accordion-index="' + tabIndex + '"]');
        
                        $requestedTitle.addClass(activeClass);
                        $requestedContent.stop(true, true).slideDown(time).addClass(activeClass);
        
                        if ('first' === state && !$wrapper.hasClass('wd-inited')) {
                            $requestedContent.stop(true, true).show().css('display', 'block');
                        }
        
                        $wrapper.addClass('wd-inited');
        
                    };
        
                    var deactivateActiveTab = function() {
                        var $activeTitle = $tabTitles.filter('.' + activeClass);
                        var $activeContent = $tabContents.filter('.' + activeClass);
        
                        $activeTitle.removeClass(activeClass);
                        $activeContent.stop(true, true).slideUp(time).removeClass(activeClass);
                    };

                    var getFirstTabIndex = function() {
                        return $tabTitles.first().data('accordion-index');
                    };
        
                    if ('first' === state) {
                        activateTab(getFirstTabIndex());
                    }
        
                    $tabTitles.off('click').on('click', function() {
                        var $this = $(this);
                        var tabIndex = $(this).data('accordion-index');
                        var isActiveTab = isTabActive(tabIndex);
        
                        var currentIndex = $this.parent().index();
                        var oldIndex = $this.parent().siblings().find('.wd-active').parent('.wd-tab-wrapper').index();
        
                        if ($this.hasClass('wd-active') || currentIndex === -1) {
                            oldIndex = currentIndex;
                        }
        
                        if (isActiveTab) {
                            deactivateActiveTab();
                        } else {
                            deactivateActiveTab();
                            activateTab(tabIndex);
                        }
        
            
                    });
        
                });
           
           
  
          });


        elementorFrontend.hooks.addAction('frontend/element_ready/testimonials.default', function($scope, $) {

          var carousel = $('.testimonials-wrapper .owl-carousel');

              if ( carousel.length ) {

                carousel.each( function () {

                    var owl = $(this),
                        autoplay = owl.data('autoplay'),
                        pagination = owl.data('pagination') ? owl.data('pagination') : false,
                        loop = owl.data('loop'),
                        slide_items = owl.data('slider-items');

                    owl.owlCarousel({
                      items: slide_items,
                      responsive: {
                          979: {
                              items: slide_items
                          },
                          768: {
                              items: 2
                          },
                          479: {
                              items: 1
                          },
                          0: {
                              items: 1
                          }
                      },
                        dots: pagination,
                        nav: true,
                        rtl: true,
                        autoheight: true,
                        autoplay: autoplay,
                        navText: ['<i class="fa fa-angle-right"></i>','<i class="fa fa-angle-left"></i>'],
                        loop: loop,
                    });

                });
              }

        });



        elementorFrontend.hooks.addAction('frontend/element_ready/customer_video.default', function($scope, $) {

            var carousel = $('.testimonials-wrapper .owl-carousel');
  
                if ( carousel.length ) {
  
                  carousel.each( function () {
  
                      var owl = $(this),
                          autoplay = owl.data('autoplay'),
                          pagination = owl.data('pagination') ? owl.data('pagination') : false,
                          loop = owl.data('loop'),
                          slide_items = owl.data('slider-items');
  
                      owl.owlCarousel({
                        items: slide_items,
                        responsive: {
                            979: {
                                items: slide_items
                            },
                            768: {
                                items: 2
                            },
                            479: {
                                items: 1
                            },
                            0: {
                                items: 1
                            }
                        },
                          dots: pagination,
                          nav: true,
                          rtl: true,
                          autoheight: true,
                          autoplay: autoplay,
                          navText: ['<i class="fa fa-angle-right"></i>','<i class="fa fa-angle-left"></i>'],
                          loop: loop,
                      });
  
                  });
                }
  
          });


		elementorFrontend.hooks.addAction('frontend/element_ready/Carousel_Products.default', function($scope, $) {

            var carousel = $('.courses-holder .owl-carousel');

                if ( carousel.length ) {

                    carousel.each( function() {
                      var owl = $(this),
                      autoplay = owl.data('autoplay'),
                      pagination = owl.data('pagination') ? owl.data('pagination') : false,
                      navigation = owl.data('navigation') ? owl.data('navigation') : false,
                      loop = owl.data('loop'),
                      slide_items = owl.data('slider-items');

                  owl.owlCarousel({
                      items: slide_items,
                      responsive: {
                          979: {
                              items: slide_items
                          },
                          768: {
                              items: 2
                          },
                          479: {
                              items: 1
                          },
                          0: {
                              items: 1
                          }
                      },
                      dots: pagination,
                      nav: navigation,
                      autoplay: autoplay,
                      autoheight: true,
                      navText: ['<i class="fa fa-angle-right"></i>','<i class="fa fa-angle-left"></i>'],
                      rtl: true,
                      loop: loop,

                            onRefreshed: function() {
                                $(window).resize();
                            }
                        });
                    });

                }

        });


		elementorFrontend.hooks.addAction('frontend/element_ready/blog-carousel.default', function($scope, $) {

            var carousel = $('.blog-posts-holder .owl-carousel');

                if ( carousel.length ) {

                    carousel.each( function() {
                      var owl = $(this),
                      autoplay = owl.data('autoplay'),
                      pagination = owl.data('pagination') ? owl.data('pagination') : false,
                      navigation = owl.data('navigation') ? owl.data('navigation') : false,
                      loop = owl.data('loop'),
                      slide_items = owl.data('slider-items');

                  owl.owlCarousel({
                      items: slide_items,
                      responsive: {
                          979: {
                              items: slide_items
                          },
                          768: {
                              items: 2
                          },
                          479: {
                              items: 1
                          },
                          0: {
                              items: 1
                          }
                      },
                      dots: pagination,
                      nav: navigation,
                      autoplay: autoplay,
                      autoheight: true,
                      navText: ['<i class="fa fa-angle-right"></i>','<i class="fa fa-angle-left"></i>'],
                      rtl: true,
                      loop: loop,

                            onRefreshed: function() {
                                $(window).resize();
                            }
                        });
                    });

                }

        });


        elementorFrontend.hooks.addAction('frontend/element_ready/Swiper_Products.default', function($scope, $) {

          let swiper = new Swiper ('.swiper-container-5', {
            effect: 'coverflow',
            centeredSlides: true,
            slidesPerView: "auto",
            grabCursor: true,
            initialSlide: 2,
            speed: 700,
            keyboardControl: true,
            coverflowEffect: {
              rotate: 0,
              stretch: 50,
              depth: 400,
              modifier: 1,
              slideShadows: true,
            },
            pagination: {
              el: '.swiper-pagination',
              clickable: true,
            },
            navigation: {
              nextEl: '.swiper-button-next',
              prevEl: '.swiper-button-prev',
            },
          });

            });



            elementorFrontend.hooks.addAction('frontend/element_ready/blog-podcast.default', function($scope, $) {

              let swiper = new Swiper('.blog-slider', {
								spaceBetween: 30,
								effect: 'fade',
								loop: true,
								grabCursor: true,
								// autoHeight: true,
								pagination: {
								el: '.blog-slider__pagination',
								clickable: true,
								}
							});

                });


    });


})(jQuery);



